const API_URL = 'https://os.md/api/extension';

document.addEventListener('DOMContentLoaded', async () => {
  // Get current tab URL and auto-fill
  try {
    const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
    if (tab?.url && !tab.url.startsWith('chrome://') && !tab.url.startsWith('about:')) {
      document.getElementById('url').value = tab.url;
    }
  } catch (e) {
    console.log('Could not get tab URL');
  }

  // Toggle custom slug field
  document.getElementById('toggleCustom').addEventListener('click', () => {
    const group = document.getElementById('customGroup');
    const btn = document.getElementById('toggleCustom');
    group.classList.toggle('hidden');
    btn.textContent = group.classList.contains('hidden') ? '+ Custom slug' : '− Custom slug';
  });
});

document.getElementById('form').addEventListener('submit', async (e) => {
  e.preventDefault();

  const url = document.getElementById('url').value.trim();
  const custom = document.getElementById('custom').value.trim();
  const submitBtn = document.getElementById('submitBtn');
  const result = document.getElementById('result');
  const shortUrl = document.getElementById('shortUrl');

  if (!url) return;

  submitBtn.disabled = true;
  submitBtn.textContent = 'Shortening...';
  result.style.display = 'none';

  try {
    const body = { url: url };
    if (custom) {
      body.custom = custom;
    }

    const response = await fetch(API_URL, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'X-Extension-Key': 'extosmd2024'
      },
      body: JSON.stringify(body)
    });

    const data = await response.json();

    result.style.display = 'block';

    if (data.success) {
      result.classList.remove('error');
      shortUrl.textContent = data.display || data.url;
      document.getElementById('copyBtn').onclick = () => {
        navigator.clipboard.writeText(data.url);
        document.getElementById('copyBtn').textContent = 'Copied!';
        setTimeout(() => {
          document.getElementById('copyBtn').textContent = 'Copy to Clipboard';
        }, 2000);
      };
    } else {
      result.classList.add('error');
      shortUrl.textContent = data.error || 'Failed to shorten URL';
    }
  } catch (err) {
    result.style.display = 'block';
    result.classList.add('error');
    shortUrl.textContent = 'Connection error. Try again.';
  }

  submitBtn.disabled = false;
  submitBtn.textContent = 'Shorten';
});
